/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.http;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.mapapi.JNIInitializer;
import com.baidu.mapapi.common.Logger;
import com.baidu.mapapi.http.b;
import com.baidu.mapsdkplatform.comapi.util.PermissionCheck;
import com.baidu.mapsdkplatform.comapi.util.f;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpClient {
    private String b = null;
    private String c = null;
    HttpURLConnection a;
    private int d;
    public static boolean isHttpsEnable = false;
    private int e;
    private String f;
    private ProtoResultCallback g;

    public void setReadTimeOut(int n2) {
        this.e = n2;
    }

    public void setMaxTimeOut(int n2) {
        this.d = n2;
    }

    public HttpClient(String string, ProtoResultCallback protoResultCallback) {
        this.f = string;
        this.g = protoResultCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void request(String string) {
        block20: {
            this.b = string;
            if (!this.checkNetwork()) {
                this.g.onFailed(HttpStateError.NETWORK_ERROR);
                return;
            }
            this.a = this.a();
            if (this.a == null) {
                Log.e((String)"HttpClient", (String)"url connection failed");
                this.g.onFailed(HttpStateError.INNER_ERROR);
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.b)) {
                this.g.onFailed(HttpStateError.REQUEST_ERROR);
                return;
            }
            int n2 = -1;
            try {
                BufferedReader bufferedReader = null;
                this.a.connect();
                InputStream inputStream = null;
                try {
                    n2 = this.a.getResponseCode();
                    if (200 == n2) {
                        int n3;
                        inputStream = this.a.getInputStream();
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((n3 = bufferedReader.read()) != -1) {
                            stringBuffer.append((char)n3);
                        }
                        this.c = stringBuffer.toString();
                        this.a(this.c);
                        break block20;
                    }
                    Log.e((String)"HttpClient", (String)("responseCode is: " + n2));
                    HttpStateError httpStateError = HttpStateError.NO_ERROR;
                    httpStateError = n2 >= 500 ? HttpStateError.SERVER_ERROR : (n2 >= 400 ? HttpStateError.REQUEST_ERROR : HttpStateError.INNER_ERROR);
                    if (Logger.debugEnable()) {
                        inputStream = this.a.getErrorStream();
                        Logger.logW("HttpClient", inputStream.toString());
                    } else {
                        Logger.logW("HttpClient", "Get response from server failed, http response code=" + n2 + ", error=" + (Object)((Object)httpStateError));
                    }
                    this.g.onFailed(httpStateError);
                    return;
                }
                catch (Exception exception) {
                    if (Logger.debugEnable()) {
                        exception.printStackTrace();
                    } else {
                        Logger.logW("HttpClient", exception.getMessage());
                    }
                    Log.e((String)"HttpClient", (String)"Catch exception. INNER_ERROR");
                    this.g.onFailed(HttpStateError.INNER_ERROR);
                    return;
                }
                finally {
                    if (inputStream != null && bufferedReader != null) {
                        bufferedReader.close();
                        inputStream.close();
                    }
                    if (null != this.a) {
                        this.a.disconnect();
                    }
                }
            }
            catch (Exception exception) {
                if (Logger.debugEnable()) {
                    exception.printStackTrace();
                } else {
                    Logger.logW("HttpClient", exception.getMessage());
                }
                Log.e((String)"HttpClient", (String)"Catch connection exception, INNER_ERROR");
                this.g.onFailed(HttpStateError.INNER_ERROR);
                return;
            }
        }
        this.g.onSuccess(this.c);
    }

    protected boolean checkNetwork() {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)JNIInitializer.getCachedContext().getSystemService("connectivity");
            if (null == connectivityManager) {
                return false;
            }
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isAvailable()) {
                return false;
            }
        }
        catch (Exception exception) {
            if (Logger.debugEnable()) {
                exception.printStackTrace();
            } else {
                Logger.logW("HttpClient", exception.getMessage());
            }
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private HttpURLConnection a() {
        try {
            HttpURLConnection httpURLConnection;
            URL uRL = new URL(this.b);
            if (isHttpsEnable) {
                httpURLConnection = (HttpsURLConnection)uRL.openConnection();
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(new b(this));
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setRequestMethod(this.f);
            httpURLConnection.setDoOutput(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setConnectTimeout(this.d);
            httpURLConnection.setReadTimeout(this.e);
            return httpURLConnection;
        }
        catch (Exception exception) {
            Log.e((String)"HttpClient", (String)"url connect failed");
            if (Logger.debugEnable()) {
                exception.printStackTrace();
            } else {
                Logger.logW("HttpClient", exception.getMessage());
            }
            return null;
        }
    }

    public static String getPhoneInfo() {
        return com.baidu.mapsdkplatform.comapi.util.f.c();
    }

    public static String getAuthToken() {
        return com.baidu.mapsdkplatform.comapi.util.f.z;
    }

    private void a(String string) {
        int n2 = -1;
        int n3 = 0;
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("status") || jSONObject.has("status_sp")) {
                n3 = jSONObject.has("status") ? jSONObject.getInt("status") : jSONObject.getInt("status_sp");
                switch (n3) {
                    case 105: 
                    case 106: {
                        n2 = PermissionCheck.permissionCheck();
                        if (0 == n2) break;
                        Log.e((String)"HttpClient", (String)("permissionCheck result is: " + n2));
                        break;
                    }
                }
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)"HttpClient", (String)"Parse json happened exception");
            jSONException.printStackTrace();
        }
    }

    public static enum HttpStateError {
        NO_ERROR,
        NETWORK_ERROR,
        INNER_ERROR,
        REQUEST_ERROR,
        SERVER_ERROR;

    }

    public static abstract class ProtoResultCallback {
        public abstract void onSuccess(String var1);

        public abstract void onFailed(HttpStateError var1);
    }
}

