/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.context;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.miekir.common.context.ContextWrapper;

public enum GlobalContext {
    INSTANCE;

    private ContextWrapper mContextWrapper;
    private Handler mMainHandler;

    public static GlobalContext getInstance() {
        return INSTANCE;
    }

    public void initContext(Context context) {
        this.mContextWrapper = new ContextWrapper(context);
        this.mMainHandler = new Handler(Looper.getMainLooper());
    }

    public static Context getContext() {
        GlobalContext instance = GlobalContext.getInstance();
        if (instance.mContextWrapper == null) {
            return null;
        }
        return instance.mContextWrapper.getContext();
    }

    public static void runOnUiThread(Runnable runnable) {
        if (GlobalContext.getInstance().mMainHandler == null) {
            Log.e((String)((Object)((Object)GlobalContext.getInstance())).getClass().getName(), (String)"\u5c1d\u8bd5\u5728\u4e3b\u7ebf\u7a0b\u8fd0\u884c\u4efb\u52a1\u5931\u8d25");
            return;
        }
        GlobalContext.getInstance().mMainHandler.post(runnable);
    }
}

