/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.tools;

import android.app.Activity;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;

public final class KeyboardTools {
    private KeyboardTools() {
    }

    public static void requestInputFocus(@NonNull Activity activity, final @NonNull View view) {
        view.requestFocus();
        activity.getWindow().setSoftInputMode(4);
        view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                view.dispatchTouchEvent(MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)0, (float)0.0f, (float)0.0f, (int)0));
                view.dispatchTouchEvent(MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)1, (float)0.0f, (float)0.0f, (int)0));
                view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    public static void hideInputMethod(@NonNull Activity activity, View rootView) {
        InputMethodManager imm = (InputMethodManager)activity.getApplicationContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        View currentFocusView = activity.getCurrentFocus();
        if (currentFocusView != null) {
            imm.hideSoftInputFromWindow(currentFocusView.getWindowToken(), 2);
        }
        if (rootView != null) {
            rootView.requestFocus();
        }
    }
}

