/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.widget.AppCompatTextView;
import java.util.ArrayList;
import java.util.List;

public class AlignTextView
extends AppCompatTextView {
    private List<String> lines = new ArrayList<String>();
    private List<Integer> tailLines = new ArrayList<Integer>();
    private Align align = Align.ALIGN_LEFT;
    private float lineSpacingMultiplier = 1.0f;
    private float lineSpacingAdd = 0.0f;
    String oldText;

    public AlignTextView(Context context) {
        super(context);
        this.setTextIsSelectable(false);
    }

    public AlignTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setTextIsSelectable(false);
        this.lineSpacingMultiplier = attrs.getAttributeFloatValue("http://schemas.android.com/apk/res/android", "lineSpacingMultiplier", 1.0f);
        int[] attributes = new int[]{16843287};
        TypedArray arr = context.obtainStyledAttributes(attrs, attributes);
        this.lineSpacingAdd = arr.getDimensionPixelSize(0, 0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (heightMode == 0x40000000) {
            this.setMeasuredDimension(this.getMeasuredWidth(), heightSize);
        } else {
            this.recalc();
            int height = this.lines.size() * this.getLineHeight();
            if (heightMode == Integer.MIN_VALUE) {
                this.setMeasuredDimension(this.getMeasuredWidth(), Math.min(heightSize, height));
            } else {
                this.setMeasuredDimension(this.getMeasuredWidth(), height);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        TextPaint paint = this.getPaint();
        paint.setColor(this.getCurrentTextColor());
        paint.drawableState = this.getDrawableState();
        Paint.FontMetrics fm = paint.getFontMetrics();
        float firstHeight = this.getTextSize() - (fm.bottom - fm.descent + fm.ascent - fm.top);
        int gravity = this.getGravity();
        if ((gravity & 0x1000) == 0) {
            firstHeight += (this.getTextSize() - firstHeight) / 2.0f;
        }
        int paddingTop = this.getPaddingTop();
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int width = this.getMeasuredWidth() - paddingLeft - paddingRight;
        for (int i = 0; i < this.lines.size(); ++i) {
            float drawY = (float)(i * this.getLineHeight()) + firstHeight;
            String line = this.lines.get(i);
            float drawSpacingX = paddingLeft;
            float gap = (float)width - paint.measureText(line);
            float interval = gap / (float)(line.length() - 1);
            if (this.tailLines.contains(i)) {
                interval = 0.0f;
                if (this.align == Align.ALIGN_CENTER) {
                    drawSpacingX += gap / 2.0f;
                } else if (this.align == Align.ALIGN_RIGHT) {
                    drawSpacingX += gap;
                }
            }
            for (int j = 0; j < line.length(); ++j) {
                float drawX = paint.measureText(line.substring(0, j)) + interval * (float)j;
                canvas.drawText(line.substring(j, j + 1), drawX + drawSpacingX, drawY + (float)paddingTop, (Paint)paint);
            }
        }
    }

    public void setAlign(Align align) {
        this.align = align;
        this.invalidate();
    }

    private void recalc() {
        String[] items;
        String text = this.getText().toString();
        if (text.equals(this.oldText)) {
            return;
        }
        this.oldText = text;
        TextPaint paint = this.getPaint();
        this.lines.clear();
        this.tailLines.clear();
        for (String item : items = text.split("\\n")) {
            this.calc((Paint)paint, item);
        }
    }

    private void calc(Paint paint, String text) {
        if (text.length() == 0) {
            this.lines.add("\n");
            return;
        }
        int width = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int startPosition = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (paint.measureText(text.substring(startPosition, i + 1)) > (float)width) {
                startPosition = i--;
                this.lines.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(text.charAt(i));
        }
        if (sb.length() > 0) {
            this.lines.add(sb.toString());
        }
        this.tailLines.add(this.lines.size() - 1);
    }

    public static enum Align {
        ALIGN_LEFT,
        ALIGN_CENTER,
        ALIGN_RIGHT;

    }
}

