/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.widget;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.miekir.common.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SwipePanel
extends FrameLayout {
    private static final String TAG = "SwipePanel";
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    private static final float TRIGGER_PROGRESS = 0.95f;
    private int mWidth;
    private int mHeight;
    private Paint mPaint;
    private float halfSize;
    private float unit;
    private int mTouchSlop;
    private Path[] mPath = new Path[4];
    private int[] mPaintColor = new int[4];
    private int[] mEdgeSizes = new int[4];
    private Drawable[] mDrawables = new Drawable[4];
    private boolean[] mIsStart = new boolean[4];
    private float[] mDown = new float[4];
    private float[] progresses = new float[4];
    private float[] preProgresses = new float[4];
    private boolean[] mIsCenter = new boolean[4];
    private boolean[] mEnabled = new boolean[]{true, true, true, true};
    private float mDownX;
    private float mDownY;
    private float mCurrentX;
    private float mCurrentY;
    private Rect mRect = new Rect();
    private boolean mIsEdgeStart;
    private int mStartDirection = -1;
    private int mLimit;
    private OnFullSwipeListener mListener;
    private OnProgressChangedListener mProgressListener;
    private float curPathX;
    private float curPathY;
    private static final Object LOCK = new Object();
    private static TypedValue sTempValue;

    public SwipePanel(@NonNull Context context) {
        this(context, null);
    }

    public SwipePanel(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        int edgeSlop = ViewConfiguration.get((Context)context).getScaledEdgeSlop();
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mPaint = new Paint(5);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.halfSize = SwipePanel.dp2px(72.0f);
        this.unit = this.halfSize / 16.0f;
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SwipePanel);
            this.setLeftSwipeColor(ta.getColor(R.styleable.SwipePanel_leftSwipeColor, -16777216));
            this.setTopSwipeColor(ta.getColor(R.styleable.SwipePanel_topSwipeColor, -16777216));
            this.setRightSwipeColor(ta.getColor(R.styleable.SwipePanel_rightSwipeColor, -16777216));
            this.setBottomSwipeColor(ta.getColor(R.styleable.SwipePanel_bottomSwipeColor, -16777216));
            this.setLeftEdgeSize(ta.getDimensionPixelSize(R.styleable.SwipePanel_leftEdgeSize, edgeSlop));
            this.setTopEdgeSize(ta.getDimensionPixelSize(R.styleable.SwipePanel_topEdgeSize, edgeSlop));
            this.setRightEdgeSize(ta.getDimensionPixelSize(R.styleable.SwipePanel_rightEdgeSize, edgeSlop));
            this.setBottomEdgeSize(ta.getDimensionPixelSize(R.styleable.SwipePanel_bottomEdgeSize, edgeSlop));
            this.setLeftDrawable(ta.getDrawable(R.styleable.SwipePanel_leftDrawable));
            this.setTopDrawable(ta.getDrawable(R.styleable.SwipePanel_topDrawable));
            this.setRightDrawable(ta.getDrawable(R.styleable.SwipePanel_rightDrawable));
            this.setBottomDrawable(ta.getDrawable(R.styleable.SwipePanel_bottomDrawable));
            this.setLeftCenter(ta.getBoolean(R.styleable.SwipePanel_isLeftCenter, false));
            this.setTopCenter(ta.getBoolean(R.styleable.SwipePanel_isTopCenter, false));
            this.setRightCenter(ta.getBoolean(R.styleable.SwipePanel_isRightCenter, false));
            this.setBottomCenter(ta.getBoolean(R.styleable.SwipePanel_isBottomCenter, false));
            this.setLeftEnabled(ta.getBoolean(R.styleable.SwipePanel_isLeftEnabled, true));
            this.setTopEnabled(ta.getBoolean(R.styleable.SwipePanel_isTopEnabled, true));
            this.setRightEnabled(ta.getBoolean(R.styleable.SwipePanel_isRightEnabled, true));
            this.setBottomEnabled(ta.getBoolean(R.styleable.SwipePanel_isBottomEnabled, true));
            ta.recycle();
        }
    }

    public void setLeftSwipeColor(int color) {
        this.setSwipeColor(color, 0);
    }

    public void setTopSwipeColor(int color) {
        this.setSwipeColor(color, 1);
    }

    public void setRightSwipeColor(int color) {
        this.setSwipeColor(color, 2);
    }

    public void setBottomSwipeColor(int color) {
        this.setSwipeColor(color, 3);
    }

    private void setSwipeColor(int color, int direction) {
        this.mPaintColor[direction] = color;
    }

    public void setLeftEdgeSize(int size) {
        this.mEdgeSizes[0] = size;
    }

    public void setTopEdgeSize(int size) {
        this.mEdgeSizes[1] = size;
    }

    public void setRightEdgeSize(int size) {
        this.mEdgeSizes[2] = size;
    }

    public void setBottomEdgeSize(int size) {
        this.mEdgeSizes[3] = size;
    }

    public void setLeftDrawable(@DrawableRes int drawableId) {
        this.setDrawable(drawableId, 0);
    }

    public void setTopDrawable(@DrawableRes int drawableId) {
        this.setDrawable(drawableId, 1);
    }

    public void setRightDrawable(@DrawableRes int drawableId) {
        this.setDrawable(drawableId, 2);
    }

    public void setBottomDrawable(@DrawableRes int drawableId) {
        this.setDrawable(drawableId, 3);
    }

    private void setDrawable(int drawableId, int direction) {
        this.mDrawables[direction] = SwipePanel.getDrawable(this.getContext(), drawableId);
    }

    public void setLeftDrawable(Drawable drawable) {
        this.setDrawable(drawable, 0);
    }

    public void setTopDrawable(Drawable drawable) {
        this.setDrawable(drawable, 1);
    }

    public void setRightDrawable(Drawable drawable) {
        this.setDrawable(drawable, 2);
    }

    public void setBottomDrawable(Drawable drawable) {
        this.setDrawable(drawable, 3);
    }

    private void setDrawable(Drawable drawable, int direction) {
        this.mDrawables[direction] = drawable;
    }

    public Drawable getLeftDrawable() {
        return this.mDrawables[0];
    }

    public Drawable getTopDrawable() {
        return this.mDrawables[1];
    }

    public Drawable getRightDrawable() {
        return this.mDrawables[2];
    }

    public Drawable getBottomDrawable() {
        return this.mDrawables[3];
    }

    public void setLeftCenter(boolean isCenter) {
        this.setCenter(isCenter, 0);
    }

    public void setTopCenter(boolean isCenter) {
        this.setCenter(isCenter, 1);
    }

    public void setRightCenter(boolean isCenter) {
        this.setCenter(isCenter, 2);
    }

    public void setBottomCenter(boolean isCenter) {
        this.setCenter(isCenter, 3);
    }

    private void setCenter(boolean isCenter, int direction) {
        this.mIsCenter[direction] = isCenter;
    }

    public void setLeftEnabled(boolean enabled) {
        this.setEnabled(enabled, 0);
    }

    public void setTopEnabled(boolean enabled) {
        this.setEnabled(enabled, 1);
    }

    public void setRightEnabled(boolean enabled) {
        this.setEnabled(enabled, 2);
    }

    public void setBottomEnabled(boolean enabled) {
        this.setEnabled(enabled, 3);
    }

    private void setEnabled(boolean enabled, int direction) {
        this.mEnabled[direction] = enabled;
    }

    public void wrapView(@NonNull View view) {
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)parent;
            int i = group.indexOfChild(view);
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            group.removeViewAt(i);
            group.addView((View)this, i, layoutParams);
            this.addView(view, -1, -1);
        } else {
            this.addView(view, -1, -1);
        }
    }

    public void setOnFullSwipeListener(OnFullSwipeListener listener) {
        this.mListener = listener;
    }

    public void setOnProgressChangedListener(OnProgressChangedListener listener) {
        this.mProgressListener = listener;
    }

    public boolean isOpen(int direction) {
        return this.progresses[direction] >= 0.95f;
    }

    public void close() {
        this.close(true);
    }

    public void close(int direction) {
        this.close(direction, true);
    }

    public void close(boolean isAnim) {
        if (isAnim) {
            this.animClose();
        } else {
            this.progresses[0] = 0.0f;
            this.progresses[1] = 0.0f;
            this.progresses[2] = 0.0f;
            this.progresses[3] = 0.0f;
            this.postInvalidate();
        }
    }

    public void close(int direction, boolean isAnim) {
        if (isAnim) {
            this.animClose(direction);
        } else {
            this.progresses[direction] = 0.0f;
            this.postInvalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
        this.mLimit = Math.min(this.mWidth, this.mHeight) / 3;
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.drawPath(canvas);
    }

    private void drawPath(Canvas canvas) {
        this.drawPath(canvas, 0);
        this.drawPath(canvas, 1);
        this.drawPath(canvas, 2);
        this.drawPath(canvas, 3);
    }

    private void drawPath(Canvas canvas, int direction) {
        if (this.mPath[direction] == null || this.progresses[direction] <= 0.0f) {
            return;
        }
        this.updatePaint(direction);
        canvas.drawPath(this.getPath(direction), this.mPaint);
        this.drawIcon(canvas, direction);
    }

    private Path getPath(int direction) {
        if (this.preProgresses[direction] != this.progresses[direction]) {
            int mark;
            float edge;
            this.mPath[direction].reset();
            float pivot = this.mDown[direction];
            if (direction == 0) {
                edge = 0.0f;
                mark = 1;
            } else if (direction == 1) {
                edge = 0.0f;
                mark = 1;
            } else if (direction == 2) {
                edge = this.mWidth;
                mark = -1;
            } else {
                edge = this.mHeight;
                mark = -1;
            }
            if (direction == 0 || direction == 2) {
                this.curPathX = edge;
                this.curPathY = pivot - this.halfSize;
            } else {
                this.curPathX = pivot - this.halfSize;
                this.curPathY = edge;
            }
            this.mPath[direction].moveTo(this.curPathX, this.curPathY);
            this.quad(edge, pivot - this.halfSize, direction);
            this.quad(edge + this.progresses[direction] * this.unit * (float)mark, pivot - this.halfSize + 5.0f * this.unit, direction);
            this.quad(edge + this.progresses[direction] * 10.0f * this.unit * (float)mark, pivot, direction);
            this.quad(edge + this.progresses[direction] * this.unit * (float)mark, pivot + this.halfSize - 5.0f * this.unit, direction);
            this.quad(edge, pivot + this.halfSize, direction);
            this.quad(edge, pivot + this.halfSize, direction);
        }
        return this.mPath[direction];
    }

    private void drawIcon(Canvas canvas, int direction) {
        int height;
        int width;
        if (this.mDrawables[direction] == null) {
            return;
        }
        int dWidth = this.mDrawables[direction].getIntrinsicWidth();
        int dHeight = this.mDrawables[direction].getIntrinsicHeight();
        int fitSize = (int)(this.progresses[direction] * 5.0f * this.unit);
        int deltaWidth = 0;
        int deltaHeight = 0;
        if (dWidth >= dHeight) {
            width = fitSize;
            height = width * dHeight / dWidth;
            deltaHeight = fitSize - height;
        } else {
            height = fitSize;
            width = height * dWidth / dHeight;
            deltaWidth = fitSize - width;
        }
        if (direction == 0) {
            this.mRect.left = (int)(0.0f + this.progresses[direction] * this.unit * 1.0f + (float)(deltaWidth / 2 * 1));
            this.mRect.top = (int)(this.mDown[0] - (float)(height / 2));
            this.mRect.right = this.mRect.left + width;
            this.mRect.bottom = this.mRect.top + height;
        } else if (direction == 2) {
            this.mRect.right = (int)((float)this.mWidth + this.progresses[direction] * this.unit * -1.0f + (float)(deltaWidth / 2 * -1));
            this.mRect.top = (int)(this.mDown[2] - (float)height / 2.0f);
            this.mRect.left = this.mRect.right - width;
            this.mRect.bottom = this.mRect.top + height;
        } else if (direction == 1) {
            this.mRect.left = (int)(this.mDown[1] - (float)(width / 2));
            this.mRect.top = (int)(0.0f + this.progresses[direction] * this.unit * 1.0f + (float)(deltaHeight / 2 * 1));
            this.mRect.right = this.mRect.left + width;
            this.mRect.bottom = this.mRect.top + height;
        } else {
            this.mRect.left = (int)(this.mDown[3] - (float)(width / 2));
            this.mRect.bottom = (int)((float)this.mHeight + this.progresses[direction] * this.unit * -1.0f + (float)(deltaHeight / 2 * -1));
            this.mRect.top = this.mRect.bottom - height;
            this.mRect.right = this.mRect.left + width;
        }
        this.mDrawables[direction].setBounds(this.mRect);
        this.mDrawables[direction].draw(canvas);
    }

    private void quad(float pathX, float pathY, int direction) {
        float preX = this.curPathX;
        float preY = this.curPathY;
        if (direction == 0 || direction == 2) {
            this.curPathX = pathX;
            this.curPathY = pathY;
        } else {
            this.curPathX = pathY;
            this.curPathY = pathX;
        }
        this.mPath[direction].quadTo(preX, preY, (preX + this.curPathX) / 2.0f, (preY + this.curPathY) / 2.0f);
    }

    private void updatePaint(int direction) {
        this.mPaint.setColor(this.mPaintColor[direction]);
        float alphaProgress = this.progresses[direction];
        if (alphaProgress < 0.25f) {
            alphaProgress = 0.25f;
        } else if (alphaProgress > 0.75f) {
            alphaProgress = 0.75f;
        }
        this.mPaint.setAlpha((int)(alphaProgress * 255.0f));
    }

    private void animClose() {
        this.animClose(0);
        this.animClose(1);
        this.animClose(2);
        this.animClose(3);
    }

    private void animClose(final int direction) {
        if (this.progresses[direction] > 0.0f) {
            final ValueAnimator anim = ValueAnimator.ofFloat((float[])new float[]{this.progresses[direction], 0.0f});
            anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((SwipePanel)SwipePanel.this).progresses[direction] = ((Float)anim.getAnimatedValue()).floatValue();
                    if (SwipePanel.this.mProgressListener != null) {
                        SwipePanel.this.mProgressListener.onProgressChanged(direction, SwipePanel.this.progresses[direction], false);
                    }
                    SwipePanel.this.postInvalidate();
                }
            });
            anim.setDuration(100L).start();
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public boolean dispatchTouchEvent(MotionEvent ev) {
        super.dispatchTouchEvent(ev);
        int action = ev.getAction();
        if (action == 0) {
            this.mDownX = ev.getX();
            this.mDownY = ev.getY();
            this.mIsStart[0] = this.mEnabled[0] && this.mDrawables[0] != null && !this.isOpen(0) && this.mDownX <= (float)this.mEdgeSizes[0];
            this.mIsStart[1] = this.mEnabled[1] && this.mDrawables[1] != null && !this.isOpen(1) && this.mDownY <= (float)this.mEdgeSizes[1];
            this.mIsStart[2] = this.mEnabled[2] && this.mDrawables[2] != null && !this.isOpen(2) && this.mDownX >= (float)(this.getWidth() - this.mEdgeSizes[2]);
            this.mIsStart[3] = this.mEnabled[3] && this.mDrawables[3] != null && !this.isOpen(3) && this.mDownY >= (float)(this.getHeight() - this.mEdgeSizes[3]);
            boolean bl = this.mIsEdgeStart = this.mIsStart[0] || this.mIsStart[1] || this.mIsStart[2] || this.mIsStart[3];
            if (this.mIsEdgeStart) {
                this.mStartDirection = -1;
            }
            return true;
        }
        if (this.mIsEdgeStart) {
            if (action == 2) {
                this.mCurrentX = ev.getX();
                this.mCurrentY = ev.getY();
                if (this.mStartDirection == -1) {
                    float deltaX = this.mCurrentX - this.mDownX;
                    float deltaY = this.mCurrentY - this.mDownY;
                    float disX = Math.abs(deltaX);
                    float disY = Math.abs(deltaY);
                    if (disX > (float)this.mTouchSlop || disY > (float)this.mTouchSlop) {
                        if (disX >= disY) {
                            if (this.mIsStart[0] && deltaX > 0.0f) {
                                this.decideDirection(0);
                            } else if (this.mIsStart[2] && deltaX < 0.0f) {
                                this.decideDirection(2);
                            }
                        } else if (this.mIsStart[1] && deltaY > 0.0f) {
                            this.decideDirection(1);
                        } else if (this.mIsStart[3] && deltaY < 0.0f) {
                            this.decideDirection(3);
                        }
                    }
                }
                if (this.mStartDirection != -1) {
                    float preProgress = this.preProgresses[this.mStartDirection];
                    this.preProgresses[this.mStartDirection] = this.progresses[this.mStartDirection];
                    this.progresses[this.mStartDirection] = this.calculateProgress();
                    if ((double)Math.abs(preProgress - this.progresses[this.mStartDirection]) > 0.01) {
                        this.postInvalidate();
                        if (this.mProgressListener != null) {
                            this.mProgressListener.onProgressChanged(this.mStartDirection, this.progresses[this.mStartDirection], true);
                        }
                    } else {
                        this.preProgresses[this.mStartDirection] = preProgress;
                    }
                }
            } else if ((action == 1 || action == 3) && this.mStartDirection != -1) {
                this.mCurrentX = ev.getX();
                this.mCurrentY = ev.getY();
                this.progresses[this.mStartDirection] = this.calculateProgress();
                if (this.isOpen(this.mStartDirection)) {
                    if (this.mListener != null) {
                        this.mListener.onFullSwipe(this.mStartDirection);
                    }
                } else {
                    this.close(this.mStartDirection, true);
                }
            }
        }
        return true;
    }

    private void decideDirection(int direction) {
        this.mDown[direction] = direction == 0 || direction == 2 ? (this.mIsCenter[direction] ? (float)this.mHeight / 2.0f : (this.mDownY < this.halfSize ? this.halfSize : (this.mDownY >= (float)this.mHeight - this.halfSize ? (float)this.mHeight - this.halfSize : this.mDownY))) : (this.mIsCenter[direction] ? (float)this.mWidth / 2.0f : (this.mDownX < this.halfSize ? this.halfSize : (this.mDownX >= (float)this.mWidth - this.halfSize ? (float)this.mWidth - this.halfSize : this.mDownX)));
        this.mStartDirection = direction;
        if (this.mPath[direction] == null) {
            this.mPath[direction] = new Path();
        }
        this.preProgresses[direction] = 0.0f;
        this.cancelChildViewTouch();
        this.requestDisallowInterceptTouchEvent(true);
    }

    private float calculateProgress() {
        if (this.mStartDirection == 0) {
            float deltaX = this.mCurrentX - this.mDownX;
            if (deltaX <= 0.0f) {
                return 0.0f;
            }
            return Math.min(deltaX / (float)this.mLimit, 1.0f);
        }
        if (this.mStartDirection == 1) {
            float deltaY = this.mCurrentY - this.mDownY;
            if (deltaY <= 0.0f) {
                return 0.0f;
            }
            return Math.min(deltaY / (float)this.mLimit, 1.0f);
        }
        if (this.mStartDirection == 2) {
            float deltaX = this.mCurrentX - this.mDownX;
            if (deltaX >= 0.0f) {
                return 0.0f;
            }
            return Math.min(-deltaX / (float)this.mLimit, 1.0f);
        }
        float deltaY = this.mCurrentY - this.mDownY;
        if (deltaY >= 0.0f) {
            return 0.0f;
        }
        return Math.min(-deltaY / (float)this.mLimit, 1.0f);
    }

    private void cancelChildViewTouch() {
        long now = SystemClock.uptimeMillis();
        MotionEvent cancelEvent = MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.getChildAt(i).dispatchTouchEvent(cancelEvent);
        }
        cancelEvent.recycle();
    }

    private static int dp2px(float dpValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Drawable getDrawable(@NonNull Context context, @DrawableRes int id2) {
        int resolvedId;
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(id2);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            return context.getResources().getDrawable(id2);
        }
        Object object = LOCK;
        synchronized (object) {
            if (sTempValue == null) {
                sTempValue = new TypedValue();
            }
            context.getResources().getValue(id2, sTempValue, true);
            resolvedId = SwipePanel.sTempValue.resourceId;
        }
        return context.getResources().getDrawable(resolvedId);
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(int var1, float var2, boolean var3);
    }

    public static interface OnFullSwipeListener {
        public void onFullSwipe(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }
}

