/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.mvp.presenter;

import android.app.Activity;
import android.content.Context;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModel;
import com.miekir.common.widget.loading.TaskDialog;
import com.miekir.mvp.view.base.IView;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

public abstract class BasePresenter<V extends IView>
extends ViewModel {
    private WeakReference<V> mViewRef;
    private CompositeDisposable mInvisibleList = new CompositeDisposable();
    private final CopyOnWriteArraySet<TaskDialog> mLoadingDialog = new CopyOnWriteArraySet();

    public void addLoadingDialog(TaskDialog dialog) {
        if (dialog == null) {
            return;
        }
        this.mLoadingDialog.add(dialog);
    }

    public void removeLoadingDialog(TaskDialog dialog) {
        if (dialog == null) {
            return;
        }
        this.mLoadingDialog.remove(dialog);
    }

    public void onActivityRecreate() {
        if (this.mLoadingDialog.isEmpty()) {
            return;
        }
        V view = this.getView();
        if (!(view instanceof Activity) && !(view instanceof Fragment)) {
            return;
        }
        if (view instanceof Fragment) {
            for (TaskDialog dialog : this.mLoadingDialog) {
                dialog.recreate(((Fragment)view).getContext());
            }
        } else {
            for (TaskDialog dialog : this.mLoadingDialog) {
                dialog.recreate((Context)view);
            }
        }
    }

    private void post(Consumer<? super V> consumer) {
    }

    public V getView() {
        return (V)(this.mViewRef == null ? null : (IView)this.mViewRef.get());
    }

    public void attachView(V view) {
        this.mViewRef = new WeakReference<V>(view);
        this.onActivityRecreate();
    }

    protected void onCleared() {
        super.onCleared();
        this.mLoadingDialog.clear();
        this.onInvisibleTaskCancel();
        if (this.mViewRef != null) {
            this.mViewRef.clear();
            this.mViewRef = null;
        }
    }

    private void onInvisibleTaskCancel() {
        this.mInvisibleList.dispose();
        this.mInvisibleList = new CompositeDisposable();
    }

    public void pushObserver(Disposable invisibleObserver) {
        this.mInvisibleList.add(invisibleObserver);
    }
}

