/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.task.net;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.miekir.common.tools.ObjectTools;
import com.miekir.task.net.tools.ClientTools;
import com.miekir.task.net.tools.InterceptorTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

class RetrofitHelper {
    private static volatile RetrofitHelper instance = null;
    private List<Interceptor> mExtraInterceptors;
    private Retrofit mRetrofit;
    private String mBaseUrl;
    private SSLSocketFactory mSslSocketFactory;
    private X509TrustManager mTrustManager;
    private long mConnectTimeout = 10000L;
    private long mReadTimeout = 10000L;
    private long mWriteTimeout = 10000L;
    private long mTotalTimeout = 30000L;
    private HashMap<String, String> mHeaderMap;
    private boolean mIsDefault;

    private RetrofitHelper(boolean isDefault) {
        this.mIsDefault = isDefault;
        if (!isDefault) {
            this.mHeaderMap = new HashMap();
        }
    }

    private static synchronized void init() {
        if (instance == null) {
            instance = new RetrofitHelper(true);
        }
    }

    public static RetrofitHelper getDefault() {
        if (instance == null) {
            RetrofitHelper.init();
        }
        return instance;
    }

    public static RetrofitHelper newInstance() {
        return new RetrofitHelper(false);
    }

    public RetrofitHelper setBaseUrl(@NonNull String url, Interceptor ... extraInterceptor) {
        return this.setBaseUrlSsl(url, null, null, extraInterceptor);
    }

    public RetrofitHelper setBaseUrlSsl(@NonNull String url, SSLSocketFactory sslSocketFactory, X509TrustManager trustManager, Interceptor ... extraInterceptor) {
        this.mExtraInterceptors = new ArrayList<Interceptor>();
        this.mBaseUrl = url;
        this.mSslSocketFactory = sslSocketFactory;
        this.mTrustManager = trustManager;
        this.setUpInterceptor(extraInterceptor);
        return this;
    }

    private void setUpInterceptor(Interceptor ... extraInterceptor) {
        Interceptor headerInterceptor = InterceptorTools.getHeaderInterceptor(this.mHeaderMap);
        List<Interceptor> interceptors = InterceptorTools.getInterceptors(headerInterceptor);
        if (this.mExtraInterceptors != null) {
            if (extraInterceptor != null && extraInterceptor.length > 0) {
                this.mExtraInterceptors.addAll(Arrays.asList(extraInterceptor));
            }
            interceptors.addAll(this.mExtraInterceptors);
        }
        this.initDefaultRetrofit(interceptors);
    }

    public RetrofitHelper setHeader(@NonNull HashMap<String, String> headerMap) {
        if (this.mIsDefault) {
            // empty if block
        }
        this.mHeaderMap = ObjectTools.clone(headerMap);
        if (!TextUtils.isEmpty((CharSequence)this.mBaseUrl)) {
            this.setUpInterceptor(new Interceptor[0]);
        }
        return this;
    }

    public RetrofitHelper addHeader(@NonNull HashMap<String, String> headerMap) {
        Map map = ObjectTools.clone(headerMap);
        this.mHeaderMap.putAll(map);
        this.setHeader(this.mHeaderMap);
        return this;
    }

    public RetrofitHelper setTimeout(long connectTimeout, long readTimeout, long writeTimeout) {
        return this.setTimeout(connectTimeout, readTimeout, writeTimeout, -1L);
    }

    public RetrofitHelper setTimeout(long totalTimeout) {
        return this.setTimeout(-1L, -1L, -1L, totalTimeout);
    }

    public RetrofitHelper setTimeout(long connectTimeout, long readTimeout, long writeTimeout, long totalTimeout) {
        this.mConnectTimeout = connectTimeout;
        this.mReadTimeout = readTimeout;
        this.mWriteTimeout = writeTimeout;
        this.mTotalTimeout = totalTimeout;
        if (!TextUtils.isEmpty((CharSequence)this.mBaseUrl)) {
            this.setUpInterceptor(new Interceptor[0]);
        }
        return this;
    }

    private void initDefaultRetrofit(List<Interceptor> interceptors) {
        OkHttpClient defaultHttpClient = ClientTools.createHttpClient(this.mSslSocketFactory, this.mTrustManager, interceptors, this.mConnectTimeout, this.mReadTimeout, this.mWriteTimeout, this.mTotalTimeout);
        this.mRetrofit = ClientTools.createRetrofit(this.mBaseUrl, defaultHttpClient);
    }

    public <T> T createApiService(@NonNull Class<T> apiClass) {
        if (TextUtils.isEmpty((CharSequence)this.mBaseUrl)) {
            throw new IllegalStateException("\u8bf7\u5148\u8c03\u7528setBaseUrl\u8bbe\u7f6e\u8bf7\u6c42URL");
        }
        return (T)this.mRetrofit.create(apiClass);
    }

    public <T> T createApiService(@NonNull String baseUrl, @NonNull OkHttpClient client, @NonNull Class<T> apiClass) {
        this.mRetrofit = ClientTools.createRetrofit(baseUrl, client);
        return (T)this.mRetrofit.create(apiClass);
    }
}

