/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.task.net.tools;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.miekir.common.context.GlobalContext;
import com.miekir.common.log.L;
import com.miekir.common.tools.DevTools;
import com.miekir.task.net.tools.InterceptorTools;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public final class ClientTools {
    private ClientTools() {
    }

    public static OkHttpClient createHttpClient(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager, List<Interceptor> interceptors, long connectTimeout, long readTimeout, long writeTimeout, long mTotalTimeout) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (interceptors != null && interceptors.size() > 0) {
            for (Interceptor interceptor : interceptors) {
                clientBuilder.addInterceptor(interceptor);
            }
        }
        if (DevTools.isDebug()) {
            clientBuilder.addInterceptor((Interceptor)InterceptorTools.getLogInterceptor());
        }
        if (connectTimeout > 0L) {
            clientBuilder.connectTimeout(connectTimeout, TimeUnit.MILLISECONDS);
        }
        if (readTimeout > 0L) {
            clientBuilder.readTimeout(readTimeout, TimeUnit.MILLISECONDS);
        }
        if (writeTimeout > 0L) {
            clientBuilder.writeTimeout(writeTimeout, TimeUnit.MILLISECONDS);
        }
        if (mTotalTimeout > 0L) {
            clientBuilder.callTimeout(mTotalTimeout, TimeUnit.MILLISECONDS);
        }
        if (sslSocketFactory != null) {
            if (trustManager != null) {
                clientBuilder.sslSocketFactory(sslSocketFactory, trustManager);
            } else {
                clientBuilder.sslSocketFactory(sslSocketFactory);
            }
        }
        return clientBuilder.build();
    }

    public static Retrofit createRetrofit(String baseUrl, boolean isLenient, OkHttpClient httpClient) {
        Retrofit.Builder builder = new Retrofit.Builder().baseUrl(baseUrl).client(httpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
        if (isLenient) {
            Gson gson = new GsonBuilder().setLenient().create();
            builder.addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson));
        } else {
            builder.addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        }
        return builder.build();
    }

    public static Retrofit createRetrofit(String baseUrl, OkHttpClient httpClient) {
        return ClientTools.createRetrofit(baseUrl, false, httpClient);
    }

    public static SSLSocketFactory getDefaultSSLContext() {
        Context context = GlobalContext.getContext();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            InputStream is = context.getAssets().open("lomsxj.crt");
            Certificate ca = cf.generateCertificate(is);
            L.i("getSSLContext ", "ca=" + ((X509Certificate)ca).getSubjectDN());
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("ca", ca);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext ssContext = SSLContext.getInstance("TLSv1", "AndroidOpenSSL");
            ssContext.init(null, tmf.getTrustManagers(), null);
            return ssContext.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

