/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.task.observer;

import android.content.Context;
import android.view.View;
import androidx.fragment.app.Fragment;
import com.miekir.common.log.L;
import com.miekir.common.widget.loading.DefaultTaskDialog;
import com.miekir.common.widget.loading.LoadingType;
import com.miekir.common.widget.loading.TaskDialog;
import com.miekir.mvp.presenter.BasePresenter;
import com.miekir.task.MvpManager;
import com.miekir.task.observer.listener.CancelListener;
import io.reactivex.disposables.Disposable;
import io.reactivex.observers.DisposableObserver;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BU\u0012\f\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0015\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0013H\u0014R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/miekir/task/observer/BaseObserver;", "T", "Lio/reactivex/observers/DisposableObserver;", "mPresenter", "Lcom/miekir/mvp/presenter/BasePresenter;", "mLoadingType", "Lcom/miekir/common/widget/loading/LoadingType;", "mTaskDialog", "Lcom/miekir/common/widget/loading/TaskDialog;", "mMessage", "", "onceTask", "", "onCancel", "Lcom/miekir/task/observer/listener/CancelListener;", "dialogContext", "Landroid/content/Context;", "(Lcom/miekir/mvp/presenter/BasePresenter;Lcom/miekir/common/widget/loading/LoadingType;Lcom/miekir/common/widget/loading/TaskDialog;Ljava/lang/String;ZLcom/miekir/task/observer/listener/CancelListener;Landroid/content/Context;)V", "onComplete", "", "onError", "e", "", "onNext", "result", "(Ljava/lang/Object;)V", "onStart", "mvp_release"})
public abstract class BaseObserver<T>
extends DisposableObserver<T> {
    @Nullable
    private BasePresenter<?> mPresenter;
    @Nullable
    private final LoadingType mLoadingType;
    @Nullable
    private TaskDialog mTaskDialog;
    @Nullable
    private final String mMessage;
    private final boolean onceTask;
    @Nullable
    private final CancelListener onCancel;
    @Nullable
    private final Context dialogContext;

    public BaseObserver(@Nullable BasePresenter<?> mPresenter, @Nullable LoadingType mLoadingType, @Nullable TaskDialog mTaskDialog, @Nullable String mMessage, boolean onceTask, @Nullable CancelListener onCancel, @Nullable Context dialogContext) {
        this.mPresenter = mPresenter;
        this.mLoadingType = mLoadingType;
        this.mTaskDialog = mTaskDialog;
        this.mMessage = mMessage;
        this.onceTask = onceTask;
        this.onCancel = onCancel;
        this.dialogContext = dialogContext;
        if (this.mPresenter == null) {
            throw new Exception("Presenter\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public /* synthetic */ BaseObserver(BasePresenter basePresenter, LoadingType loadingType, TaskDialog taskDialog, String string, boolean bl, CancelListener cancelListener, Context context, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            taskDialog = null;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            cancelListener = null;
        }
        if ((n & 0x40) != 0) {
            context = null;
        }
        this(basePresenter, loadingType, taskDialog, string, bl, cancelListener, context);
    }

    protected void onStart() {
        super.onStart();
        if (this.mLoadingType == LoadingType.INVISIBLE) {
            BasePresenter<?> basePresenter = this.mPresenter;
            if (basePresenter != null) {
                basePresenter.pushObserver((Disposable)this);
            }
        } else {
            Object object;
            BasePresenter<?> basePresenter = this.mPresenter;
            Intrinsics.checkNotNull(basePresenter);
            Object obj = basePresenter.getView();
            if (obj == null) {
                return;
            }
            Object view = obj;
            Context context = null;
            context = this.dialogContext;
            if (context == null) {
                object = view;
                if (object instanceof Context) {
                    context = (Context)view;
                } else if (object instanceof Fragment) {
                    context = ((Fragment)view).getContext();
                } else if (object instanceof View) {
                    context = ((View)view).getContext();
                }
            }
            if (context == null) {
                throw new IllegalArgumentException("Task dialog context is null");
            }
            if (this.mLoadingType != LoadingType.INVISIBLE) {
                if (this.mTaskDialog == null) {
                    this.mTaskDialog = MvpManager.getInstance().getTaskDialog();
                }
                if (this.mTaskDialog == null) {
                    this.mTaskDialog = new DefaultTaskDialog();
                }
                if ((object = this.mTaskDialog) != null) {
                    ((TaskDialog)object).setupWithDisposable(context, this.mPresenter, (Disposable)this, this.mLoadingType, this.mMessage, this.onCancel);
                }
                object = this.mTaskDialog;
                if (object != null) {
                    ((TaskDialog)object).show();
                }
                object = this.mPresenter;
                if (object != null) {
                    ((BasePresenter)((Object)object)).addLoadingDialog(this.mTaskDialog);
                }
            }
        }
    }

    public void onNext(T result) {
        if (this.mTaskDialog != null && this.onceTask) {
            Object object = this.mPresenter;
            if (object != null) {
                object.removeLoadingDialog(this.mTaskDialog);
            }
            object = this.mTaskDialog;
            if (object != null) {
                ((TaskDialog)object).dismiss();
            }
        }
    }

    public void onError(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        L.e(e.toString());
        if (this.mTaskDialog != null) {
            Object object = this.mPresenter;
            if (object != null) {
                object.removeLoadingDialog(this.mTaskDialog);
            }
            object = this.mTaskDialog;
            if (object != null) {
                ((TaskDialog)object).dismiss();
            }
        }
    }

    public void onComplete() {
        if (this.mTaskDialog != null && !this.onceTask) {
            Object object = this.mPresenter;
            if (object != null) {
                object.removeLoadingDialog(this.mTaskDialog);
            }
            object = this.mTaskDialog;
            if (object != null) {
                ((TaskDialog)object).dismiss();
            }
        }
    }
}

