/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.autosize;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.miekir.common.autosize.AutoAdaptStrategy;
import com.miekir.common.autosize.AutoSizeConfig;
import com.miekir.common.autosize.FragmentLifecycleCallbacksImplToAndroidx;

public class ActivityLifecycleCallbacksImpl
implements Application.ActivityLifecycleCallbacks {
    private AutoAdaptStrategy mAutoAdaptStrategy;
    private FragmentLifecycleCallbacksImplToAndroidx mFragmentLifecycleCallbacksToAndroidx;

    public ActivityLifecycleCallbacksImpl(AutoAdaptStrategy autoAdaptStrategy) {
        if (AutoSizeConfig.DEPENDENCY_ANDROIDX) {
            this.mFragmentLifecycleCallbacksToAndroidx = new FragmentLifecycleCallbacksImplToAndroidx(autoAdaptStrategy);
        }
        this.mAutoAdaptStrategy = autoAdaptStrategy;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (AutoSizeConfig.getInstance().isCustomFragment() && this.mFragmentLifecycleCallbacksToAndroidx != null && activity instanceof FragmentActivity) {
            ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this.mFragmentLifecycleCallbacksToAndroidx, true);
        }
        if (this.mAutoAdaptStrategy != null) {
            this.mAutoAdaptStrategy.applyAdapt(activity, activity);
        }
    }

    public void onActivityStarted(Activity activity) {
        if (this.mAutoAdaptStrategy != null) {
            this.mAutoAdaptStrategy.applyAdapt(activity, activity);
        }
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void setAutoAdaptStrategy(AutoAdaptStrategy autoAdaptStrategy) {
        this.mAutoAdaptStrategy = autoAdaptStrategy;
        if (this.mFragmentLifecycleCallbacksToAndroidx != null) {
            this.mFragmentLifecycleCallbacksToAndroidx.setAutoAdaptStrategy(autoAdaptStrategy);
        }
    }
}

