/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.exception;

import android.net.ParseException;
import android.os.NetworkOnMainThreadException;
import android.text.TextUtils;
import com.miekir.common.exception.IExceptionHandler;
import com.miekir.common.exception.ResultException;
import com.miekir.common.log.L;
import com.miekir.common.tools.DevTools;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.json.JSONException;
import retrofit2.HttpException;

final class DefaultExceptionHandler
implements IExceptionHandler {
    DefaultExceptionHandler() {
    }

    @Override
    public ResultException handleException(Throwable t) {
        String message = "";
        ResultException result = new ResultException(this.getFailedCode(), message);
        if (t instanceof UnknownHostException) {
            message = "\u7f51\u7edc\u4e0d\u53ef\u7528";
        } else if (t instanceof SocketTimeoutException) {
            message = "\u8bf7\u6c42\u7f51\u7edc\u8d85\u65f6";
        } else if (t instanceof HttpException) {
            HttpException httpException = (HttpException)t;
            result.code = httpException.code();
            if (TextUtils.isEmpty((CharSequence)message)) {
                message = this.handleHttpCode(httpException.code(), httpException.message());
            }
        } else if (t instanceof ParseException || t instanceof JSONException) {
            message = "\u6570\u636e\u89e3\u6790\u9519\u8bef";
        } else if (t instanceof NetworkOnMainThreadException) {
            message = "\u4e0d\u5141\u8bb8\u5728\u4e3b\u7ebf\u7a0b\u8bbf\u95ee\u7f51\u7edc";
        } else if (t instanceof ResultException) {
            ResultException taskException = (ResultException)t;
            result.code = taskException.code;
            message = taskException.errorMessage;
        } else {
            message = t.getMessage();
        }
        if (DevTools.isDebug()) {
            t.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)message)) {
            message = "\u672a\u77e5\u9519\u8bef";
        }
        L.e(t.toString(), "ExceptionTag");
        result.errorMessage = message;
        return result;
    }

    @Override
    public int getSuccessCode() {
        return 0;
    }

    @Override
    public int getFailedCode() {
        return -1;
    }

    @Override
    public int getCancelledCode() {
        return -2;
    }

    private String handleHttpCode(int code, String message) {
        String msg = code >= 500 && code < 600 ? "\u670d\u52a1\u5668\u5904\u7406\u8bf7\u6c42\u51fa\u9519" : (code >= 400 && code < 500 ? "\u670d\u52a1\u5668\u65e0\u6cd5\u5904\u7406\u8bf7\u6c42" : (code >= 300 && code < 400 ? "\u8bf7\u6c42\u88ab\u91cd\u5b9a\u5411\u5230\u5176\u4ed6\u9875\u9762" : message));
        return msg;
    }
}

