/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.tools;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.miekir.common.R;
import com.miekir.common.context.GlobalContext;
import com.miekir.common.permission.Permission;
import com.miekir.common.permission.PermissionResult;
import com.miekir.common.permission.RxPermissions;
import com.miekir.common.tools.ThreadTools;
import com.miekir.common.widget.SwipePanel;
import com.miekir.mvp.view.base.adapt.BasicActivity;
import com.miekir.mvp.view.result.ActivityResult;
import io.reactivex.functions.Consumer;

public final class ActivityTools {
    private ActivityTools() {
    }

    public static void requestPermissions(@NonNull FragmentActivity activity, @NonNull String[] permissions) {
        ActivityTools.requestPermissions(activity, permissions, null);
    }

    @SuppressLint(value={"CheckResult"})
    public static void requestPermissions(@NonNull Fragment fragment, @NonNull String[] permissions) {
        ActivityTools.requestPermissions(fragment, permissions, null);
    }

    @SuppressLint(value={"CheckResult"})
    public static void requestPermissions(@NonNull Fragment fragment, @NonNull String[] permissions, final PermissionResult permissionResult) {
        new RxPermissions(fragment).requestEachCombined(permissions).subscribe((Consumer)new Consumer<Permission>(){

            public void accept(Permission permission) throws Exception {
                if (permissionResult != null) {
                    permissionResult.onResult(permission.granted, permission.shouldShowRequestPermissionRationale);
                }
            }
        });
    }

    @SuppressLint(value={"CheckResult"})
    public static void requestPermissions(@NonNull FragmentActivity activity, @NonNull String[] permissions, final PermissionResult permissionResult) {
        new RxPermissions(activity).requestEachCombined(permissions).subscribe((Consumer)new Consumer<Permission>(){

            public void accept(Permission permission) throws Exception {
                if (permissionResult != null) {
                    permissionResult.onResult(permission.granted, permission.shouldShowRequestPermissionRationale);
                }
            }
        });
    }

    public static void openUrl(String webUrl) {
        if (TextUtils.isEmpty((CharSequence)webUrl)) {
            return;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        Uri uri = Uri.parse((String)webUrl);
        intent.setData(uri);
        intent.setFlags(0x10000000);
        try {
            GlobalContext.getContext().startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void openActivity(@NonNull Context context, @NonNull Intent intent) {
        if (!(context instanceof Activity)) {
            intent.setFlags(0x10000000);
        }
        if (!ThreadTools.isMainThread()) {
            GlobalContext.runOnUiThread(() -> context.startActivity(intent));
        } else {
            context.startActivity(intent);
        }
    }

    public static void openActivity(@NonNull Class<?> targetActivity) {
        Context context = GlobalContext.getContext();
        ActivityTools.openActivity(context, targetActivity);
    }

    public static void openActivity(@NonNull Context context, @NonNull Class<?> targetActivity) {
        ActivityTools.openActivity(context, targetActivity, false);
    }

    public static void openActivity(@NonNull Context context, @NonNull Class<?> targetActivity, boolean newTask) {
        Intent startIntent = new Intent(context, targetActivity);
        if (newTask) {
            startIntent.setFlags(0x10000000);
        }
        ActivityTools.openActivity(context, startIntent);
    }

    public static void openActivityForResult(@NonNull BasicActivity context, @NonNull Intent intent, @NonNull ActivityResult result) {
        context.setActivityResult(result);
        context.getActivityResultLauncher().launch((Object)intent);
    }

    public static void swipeActivity(@NonNull Activity activity) {
        ActivityTools.swipeActivity(activity, R.drawable.back_swipe, 100);
    }

    public static void swipeActivity(@NonNull Activity activity, int edgeSize) {
        ActivityTools.swipeActivity(activity, R.drawable.back_swipe, edgeSize);
    }

    public static void swipeActivity(final @NonNull Activity activity, @DrawableRes int backResourceId, int edgeSize) {
        final SwipePanel swipeLayout = new SwipePanel((Context)activity);
        swipeLayout.setLeftDrawable(backResourceId);
        swipeLayout.setLeftEdgeSize(edgeSize);
        swipeLayout.wrapView(activity.findViewById(0x1020002));
        swipeLayout.setOnFullSwipeListener(new SwipePanel.OnFullSwipeListener(){

            @Override
            public void onFullSwipe(int direction) {
                swipeLayout.close(direction);
                activity.finish();
            }
        });
    }
}

