/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.tools;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public final class JsonTools {
    private JsonTools() {
    }

    public static JsonObject getJsonFromKeyValueList(Map<String, Object> params) {
        JsonObject contentObject = new JsonObject();
        if (params == null || params.size() == 0) {
            return contentObject;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() instanceof String) {
                contentObject.addProperty(entry.getKey(), String.valueOf(entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof Number) {
                contentObject.addProperty(entry.getKey(), (Number)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                contentObject.addProperty(entry.getKey(), (Boolean)entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            List list = (List)entry.getValue();
            JsonArray jsonArray = new Gson().toJsonTree((Object)list, new TypeToken<List<?>>(){}.getType()).getAsJsonArray();
            contentObject.add(entry.getKey(), (JsonElement)jsonArray);
        }
        return contentObject;
    }

    public static JsonObject getJsonObject(Object obj) {
        Gson gson = new Gson();
        return JsonParser.parseString((String)gson.toJson(obj)).getAsJsonObject();
    }
}

