/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.tools;

import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.Toast;
import com.miekir.common.context.GlobalContext;
import com.miekir.common.tools.ThreadTools;

public final class ToastTools {
    private static final long PERIOD_SHORT = 1500L;
    private static final long PERIOD_LONG = 2500L;
    private String lastShortString;
    private String lastLongString;
    private long mLastShortToastMillis;
    private long mLastLongToastMillis;
    private int mVerticalMargin = 0;

    private ToastTools() {
    }

    private static ToastTools getInstance() {
        return Factory.INSTANCE;
    }

    public static void showShort(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        Context context = GlobalContext.getContext();
        if (context == null) {
            return;
        }
        ToastTools.initMargin(context);
        if (System.currentTimeMillis() - ToastTools.getInstance().mLastShortToastMillis > 1500L || !TextUtils.equals((CharSequence)ToastTools.getInstance().lastShortString, (CharSequence)text)) {
            ToastTools.getInstance().lastShortString = text;
            ToastTools.getInstance().mLastShortToastMillis = System.currentTimeMillis();
            if (ThreadTools.isMainThread()) {
                ToastTools.showShortOnMain(context, text);
            } else {
                GlobalContext.runOnUiThread(() -> ToastTools.showShortOnMain(context, text));
            }
        }
    }

    public static void showLong(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        Context context = GlobalContext.getContext();
        if (context == null) {
            return;
        }
        ToastTools.initMargin(context);
        if (System.currentTimeMillis() - ToastTools.getInstance().mLastLongToastMillis > 2500L || !TextUtils.equals((CharSequence)ToastTools.getInstance().lastLongString, (CharSequence)text)) {
            ToastTools.getInstance().lastLongString = text;
            ToastTools.getInstance().mLastLongToastMillis = System.currentTimeMillis();
            if (ThreadTools.isMainThread()) {
                ToastTools.showLongOnMain(context, text);
            } else {
                GlobalContext.runOnUiThread(() -> ToastTools.showLongOnMain(context, text));
            }
        }
    }

    private static void showShortOnMain(Context context, String text) {
        Toast toast = Toast.makeText((Context)context, (CharSequence)text, (int)0);
        toast.setGravity(81, 0, ToastTools.getInstance().mVerticalMargin);
        toast.show();
    }

    private static void showLongOnMain(Context context, String text) {
        Toast toast = Toast.makeText((Context)context, (CharSequence)text, (int)1);
        toast.setGravity(81, 0, ToastTools.getInstance().mVerticalMargin);
        toast.show();
    }

    private static void initMargin(Context context) {
        if (context == null) {
            return;
        }
        if (ToastTools.getInstance().mVerticalMargin == 0) {
            ToastTools.getInstance().mVerticalMargin = (int)TypedValue.applyDimension((int)1, (float)72.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
    }

    private static class Factory {
        public static ToastTools INSTANCE = new ToastTools();

        private Factory() {
        }
    }
}

