/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.widget;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public class StaggeredDecoration
extends RecyclerView.ItemDecoration {
    private int mSpace;
    private int mHalfSpace;

    public StaggeredDecoration(int space) {
        this.mSpace = space;
        this.mHalfSpace = space / 2;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        StaggeredGridLayoutManager.LayoutParams lp = (StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams();
        int spanIndex = lp.getSpanIndex();
        top = position == 0 || position == 1 ? this.mSpace : 0;
        bottom = this.mSpace;
        if (spanIndex == 0) {
            left = this.mSpace;
            right = this.mHalfSpace;
        } else {
            left = this.mHalfSpace;
            right = this.mSpace;
        }
        outRect.set(left, top, right, bottom);
    }
}

