/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.miekir.common.R;

public class SuccessFailLayout
extends FrameLayout {
    private View successView;
    private View failView;

    public SuccessFailLayout(@NonNull Context context) {
        this(context, null);
    }

    public SuccessFailLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SuccessFailLayout);
        int failViewLayoutId = ta.getResourceId(R.styleable.SuccessFailLayout_failLayout, -1);
        ta.recycle();
        this.post(() -> {
            int childCount = this.getChildCount();
            if (childCount != 1) {
                throw new IllegalStateException("SuccessFailLayout\u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u6210\u529f\u72b6\u6001\u7684\u5b50View");
            }
            this.successView = this.getChildAt(0);
            if (failViewLayoutId != -1) {
                this.setFailView(failViewLayoutId);
            }
        });
    }

    public View getFailView() {
        return this.failView;
    }

    public void setFailView(@NonNull View view) {
        if (this.failView != null) {
            this.removeView(this.failView);
        }
        this.failView = view;
        this.failView.setVisibility(8);
        this.addView(this.failView, -1, -1);
    }

    public void setFailView(@LayoutRes int layoutResId) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(layoutResId, null);
        this.setFailView(view);
    }

    public void setStatus(Status status) {
        if (status == Status.SUCCESS) {
            if (this.successView != null) {
                this.successView.setVisibility(0);
            }
            if (this.failView != null) {
                this.failView.setVisibility(8);
            }
        } else {
            if (this.successView != null) {
                this.successView.setVisibility(8);
            }
            if (this.failView != null) {
                this.failView.setVisibility(0);
            }
        }
    }

    public static enum Status {
        SUCCESS,
        FAIL;

    }
}

