/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.widget.loading;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import java.lang.ref.WeakReference;

public class CircleView
extends View {
    private float mWidth = 0.0f;
    private float mPadding = 0.0f;
    private float startAngle = 0.0f;
    private Paint mPaint;
    private ValueAnimator valueAnimator;
    private UpdateListener mUpdateListener;

    public CircleView(Context context) {
        this(context, null);
    }

    public CircleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPaint();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth() > this.getHeight() ? (float)this.getMeasuredHeight() : (float)this.getMeasuredWidth();
        this.mPadding = 5.0f;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setColor(Color.argb((int)100, (int)255, (int)255, (int)255));
        canvas.drawCircle(this.mWidth / 2.0f, this.mWidth / 2.0f, this.mWidth / 2.0f - this.mPadding, this.mPaint);
        this.mPaint.setColor(-1);
        RectF rectF = new RectF(this.mPadding, this.mPadding, this.mWidth - this.mPadding, this.mWidth - this.mPadding);
        canvas.drawArc(rectF, this.startAngle, 100.0f, false, this.mPaint);
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(-1);
        this.mPaint.setStrokeWidth(8.0f);
    }

    public void startAnim() {
        this.stopAnim();
        this.startViewAnim(0.0f, 1.0f, 1000L);
    }

    public void stopAnim() {
        if (this.valueAnimator != null) {
            this.clearAnimation();
            this.valueAnimator.setRepeatCount(1);
            this.valueAnimator.cancel();
            this.valueAnimator.end();
            this.valueAnimator.removeAllUpdateListeners();
            this.valueAnimator.removeAllListeners();
        }
        this.valueAnimator = null;
    }

    private ValueAnimator startViewAnim(float startF, float endF, long time) {
        if (this.valueAnimator != null && this.valueAnimator.isRunning()) {
            return this.valueAnimator;
        }
        this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{startF, endF});
        this.valueAnimator.setDuration(time);
        this.valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.valueAnimator.setRepeatCount(-1);
        this.valueAnimator.setRepeatMode(1);
        if (this.mUpdateListener == null) {
            this.mUpdateListener = new UpdateListener(this);
        }
        this.valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mUpdateListener);
        this.valueAnimator.start();
        return this.valueAnimator;
    }

    private static class UpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private WeakReference<CircleView> mView;

        public UpdateListener(CircleView view) {
            this.mView = new WeakReference<CircleView>(view);
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            if (this.mView == null) {
                return;
            }
            CircleView view = (CircleView)((Object)this.mView.get());
            if (view == null) {
                return;
            }
            float value = ((Float)view.valueAnimator.getAnimatedValue()).floatValue();
            view.startAngle = 360.0f * value;
            view.invalidate();
        }
    }
}

