/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.common.widget.loading;

import android.app.Dialog;
import android.content.Context;
import com.miekir.common.context.GlobalContext;
import com.miekir.common.widget.loading.LoadingType;
import com.miekir.mvp.presenter.BasePresenter;
import com.miekir.task.observer.listener.CancelListener;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.CancellationException;
import kotlinx.coroutines.Job;

public abstract class TaskDialog {
    private BasePresenter mPresenter;
    private Disposable mDisposal;
    private Job mJob;
    private CancelListener mCancelListener;
    private LoadingType mLoadingType;
    private Dialog mDialog;
    protected String mMessage;

    abstract Dialog newLoadingDialog(Context var1);

    abstract void onDismiss();

    abstract void onShow();

    public void setJob(Job job2) {
        this.mJob = job2;
    }

    public void setupWithDisposable(Context context, BasePresenter presenter, Disposable disposable, LoadingType loadingType, String message, CancelListener cancelListener) {
        if (loadingType == LoadingType.INVISIBLE) {
            return;
        }
        this.mCancelListener = cancelListener;
        this.mPresenter = presenter;
        this.createDialog(context, null, disposable, loadingType, message);
    }

    public void setupWithJob(Context context, BasePresenter presenter, Job job2, LoadingType loadingType, String message) {
        if (loadingType == LoadingType.INVISIBLE) {
            return;
        }
        this.mPresenter = presenter;
        this.createDialog(context, job2, null, loadingType, message);
    }

    public void recreate(Context context) {
        this.dismiss();
        this.createDialog(context, this.mJob, this.mDisposal, this.mLoadingType, this.mMessage);
        this.show();
    }

    private void createDialog(Context context, Job job2, Disposable disposable, LoadingType loadingType, String message) {
        if (loadingType == LoadingType.INVISIBLE) {
            return;
        }
        this.mLoadingType = loadingType;
        this.mMessage = message;
        this.mDialog = this.newLoadingDialog(context);
        this.mDialog.setCanceledOnTouchOutside(false);
        if (loadingType == LoadingType.STICKY) {
            this.mDialog.setCancelable(false);
        } else {
            this.mDialog.setCancelable(true);
            if (loadingType == LoadingType.VISIBLE) {
                this.mJob = job2;
                this.mDisposal = disposable;
                this.mDialog.setOnCancelListener(dialog -> {
                    if (this.mCancelListener != null) {
                        this.mCancelListener.onCancel();
                    }
                    this.close();
                });
            }
        }
    }

    public void show() {
        if (this.mDialog == null) {
            return;
        }
        try {
            if (!this.mDialog.isShowing()) {
                this.mDialog.show();
            }
            this.onShow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        Runnable runnable = () -> {
            this.dismiss();
            if (this.mPresenter != null) {
                this.mPresenter.removeLoadingDialog(this);
            }
            this.mPresenter = null;
            if (this.mJob != null && this.mJob.isActive()) {
                this.mJob.cancel(new CancellationException("Task Cancel"));
            }
            this.mJob = null;
            if (this.mDisposal != null && !this.mDisposal.isDisposed()) {
                this.mDisposal.dispose();
            }
            this.mDisposal = null;
        };
        GlobalContext.runOnUiThread(runnable);
    }

    public void dismiss() {
        try {
            this.onDismiss();
            if (this.mDialog != null) {
                this.mDialog.setOnCancelListener(null);
                this.mDialog.dismiss();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mDialog = null;
    }
}

