/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.task;

import androidx.annotation.NonNull;
import com.miekir.common.exception.ExceptionManager;
import com.miekir.common.exception.IExceptionHandler;
import com.miekir.common.log.ILogHandler;
import com.miekir.common.log.L;
import com.miekir.common.log.LogCallback;
import com.miekir.common.widget.loading.TaskDialog;
import com.miekir.mvp.view.anim.AbstractAnimHandler;

public class MvpManager {
    private AbstractAnimHandler mAnimHandler;
    private Class<? extends TaskDialog> mTaskDialogClass;

    private MvpManager() {
    }

    public static MvpManager getInstance() {
        return Factory.INSTANCE;
    }

    public AbstractAnimHandler getActivityAnimation() {
        return this.mAnimHandler;
    }

    public TaskDialog getTaskDialog() {
        if (this.mTaskDialogClass != null) {
            try {
                return this.mTaskDialogClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public MvpManager exceptionHandler(@NonNull IExceptionHandler handler) {
        ExceptionManager.getInstance().setExceptionHandler(handler);
        return this;
    }

    public MvpManager globalTaskDialog(Class<? extends TaskDialog> taskDialogClass) {
        this.mTaskDialogClass = taskDialogClass;
        return this;
    }

    public MvpManager logHandler(@NonNull ILogHandler handler) {
        L.setLogHandler(handler);
        return this;
    }

    public MvpManager logCallback(@NonNull LogCallback callback) {
        L.setLogCallback(callback);
        return this;
    }

    public MvpManager activityAnimation(AbstractAnimHandler handler) {
        this.mAnimHandler = handler;
        return this;
    }

    private static class Factory {
        public static final MvpManager INSTANCE = new MvpManager();

        private Factory() {
        }
    }
}

