/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.task.net.tools;

import android.text.TextUtils;
import com.miekir.common.log.L;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;

public final class InterceptorTools {
    private InterceptorTools() {
    }

    public static List<Interceptor> getInterceptors(Interceptor interceptor) {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        if (interceptor != null) {
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    public static Interceptor getHeaderInterceptor(final Map<String, String> headerMap) {
        if (headerMap == null || headerMap.isEmpty()) {
            return null;
        }
        return new Interceptor(){

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
                Set keySet = headerMap.keySet();
                Request.Builder builder = chain.request().newBuilder();
                for (String key : keySet) {
                    String value = (String)headerMap.get(key);
                    if (value == null || TextUtils.isEmpty((CharSequence)value)) continue;
                    builder.addHeader(key, value);
                }
                return chain.proceed(builder.build());
            }
        };
    }

    public static HttpLoggingInterceptor getLogInterceptor() {
        HttpLoggingInterceptor debugLogInterceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            public void log(String message) {
                L.i("Retrofit\uff1a", message);
            }
        });
        debugLogInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return debugLogInterceptor;
    }
}

