/*
 * Decompiled with CFR 0.152.
 */
package com.miekir.task.widget;

import com.miekir.common.context.GlobalContext;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

public class NetProgress {
    public Interceptor getInter(Listener listener) {
        return new Interceptor(listener);
    }

    public static interface Listener {
        public void update(long var1, long var3, boolean var5);
    }

    private static class ResponseBody
    extends okhttp3.ResponseBody {
        private final okhttp3.ResponseBody responseBody;
        private final Listener listener;
        private BufferedSource bufferedSource;

        public ResponseBody(okhttp3.ResponseBody responseBody, Listener listener) {
            this.responseBody = responseBody;
            this.listener = listener;
        }

        public MediaType contentType() {
            return this.responseBody.contentType();
        }

        public long contentLength() {
            return this.responseBody.contentLength();
        }

        public BufferedSource source() {
            if (this.bufferedSource == null) {
                this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(source){
                long totalBytesRead;
                {
                    super(x0);
                    this.totalBytesRead = 0L;
                }

                public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                    final long bytesRead = super.read(sink, byteCount);
                    this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                    GlobalContext.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.update(totalBytesRead, responseBody.contentLength(), bytesRead == -1L);
                        }
                    });
                    return bytesRead;
                }
            };
        }
    }

    public static class Interceptor
    implements okhttp3.Interceptor {
        private final Listener progressListener;

        public Interceptor(Listener listener) {
            this.progressListener = listener;
        }

        @NotNull
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Response originalResponse = chain.proceed(chain.request());
            return originalResponse.newBuilder().body((okhttp3.ResponseBody)new ResponseBody(originalResponse.body(), this.progressListener)).build();
        }
    }
}

